/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.metal;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.items.metal.ItemMetal;
import net.dries007.tfc.objects.te.TEIngotPile;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockIngotPile
extends Block {
    private static final AxisAlignedBB DEFAULT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);

    public BlockIngotPile() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TEIngotPile te = Helpers.getTE(source, pos, TEIngotPile.class);
        if (te != null) {
            double y = (float)te.getCount() / 64.0f;
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, y, 1.0);
        }
        return DEFAULT_AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        TEIngotPile te = Helpers.getTE(worldIn, pos, TEIngotPile.class);
        if (te != null && te.getCount() == 64 && face == EnumFacing.UP) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        TEIngotPile te = Helpers.getTE(worldIn, pos, TEIngotPile.class);
        double y = te != null ? 0.125 * ((double)te.getCount() / 8.0) : 1.0;
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, y, 1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        TEIngotPile te = Helpers.getTE((IBlockAccess)worldIn, pos, TEIngotPile.class);
        double y = te != null ? 0.125 * ((double)te.getCount() / 8.0) : 1.0;
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, y, 1.0);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.collapseDown(worldIn, pos) && !worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TEIngotPile te = Helpers.getTE((IBlockAccess)worldIn, pos, TEIngotPile.class);
        if (te != null) {
            te.onBreakBlock();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TEIngotPile te;
        if (!playerIn.func_70093_af() && (te = Helpers.getTE((IBlockAccess)worldIn, pos, TEIngotPile.class)) != null) {
            BlockPos posTop = pos;
            do {
                IBlockState stateTop;
                if ((stateTop = worldIn.func_180495_p(posTop = posTop.func_177984_a())).func_177230_c() != BlocksTFC.INGOT_PILE && te != null) {
                    return this.removeIngot(worldIn, playerIn, te);
                }
                te = Helpers.getTE((IBlockAccess)worldIn, posTop, TEIngotPile.class);
                if (te == null || te.getCount() >= 64) continue;
                return this.removeIngot(worldIn, playerIn, te);
            } while (posTop.func_177956_o() <= 256);
            return false;
        }
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TEIngotPile te = Helpers.getTE(world, pos, TEIngotPile.class);
        if (te == null) {
            return false;
        }
        return te.getCount() == 64;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEIngotPile();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TEIngotPile te = Helpers.getTE((IBlockAccess)world, pos, TEIngotPile.class);
        if (te != null) {
            return new ItemStack(ItemMetal.get(te.getMetal(), Metal.ItemType.INGOT));
        }
        return ItemStack.field_190927_a;
    }

    private boolean removeIngot(World worldIn, EntityPlayer playerIn, TEIngotPile te) {
        if (!worldIn.field_72995_K) {
            te.setCount(te.getCount() - 1);
            if (te.getCount() <= 0) {
                worldIn.func_175656_a(te.func_174877_v(), Blocks.field_150350_a.func_176223_P());
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)new ItemStack(ItemMetal.get(te.getMetal(), Metal.ItemType.INGOT)));
        }
        return true;
    }

    private boolean collapseDown(World world, BlockPos pos) {
        IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
        if (stateDown.func_177230_c() == BlocksTFC.INGOT_PILE) {
            TEIngotPile te = Helpers.getTE((IBlockAccess)world, pos.func_177977_b(), TEIngotPile.class);
            TEIngotPile teUp = Helpers.getTE((IBlockAccess)world, pos, TEIngotPile.class);
            if (te != null && teUp != null && te.getCount() < 64) {
                if (te.getCount() + teUp.getCount() <= 64) {
                    te.setCount(te.getCount() + teUp.getCount());
                    world.func_175698_g(pos);
                } else {
                    te.setCount(64);
                    teUp.setCount(te.getCount() + teUp.getCount() - 64);
                }
            }
            return true;
        }
        return false;
    }
}

